/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    private static InputSupplier<InputStream> newUrlInputSupplier(final URL url) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                if (url.getProtocol().equals("file")) {
                    return url.openStream();
                }
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                try {
                    HttpResponse execute = defaultHttpClient.execute((HttpUriRequest)new HttpGet(url.toURI()));
                    return execute.getEntity().getContent();
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public static void copy(URL fromUrl, File toFile) {
        try {
            Files.copy(IOUtils.newUrlInputSupplier(fromUrl), (File)toFile);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public static String getText(URL url) {
        try {
            return new String(ByteStreams.toByteArray(IOUtils.newUrlInputSupplier(url)));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public static String getText(File file) {
        try {
            return Files.toString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            for (String child : sourceLocation.list()) {
                IOUtils.copyDirectory(new File(sourceLocation, child), new File(targetLocation, child));
            }
        } else {
            try {
                Files.copy((File)sourceLocation, (File)targetLocation);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    public static String replacePlaceholders(String replaceable, ContextProperties values) {
        StringWriter writer = new StringWriter();
        IOUtils.replacePlaceholders(new StringReader(replaceable), values, writer);
        return writer.toString();
    }

    public static void replacePlaceholders(Reader replaceable, ContextProperties values, Writer writer) {
        try {
            if (values == null || values.isEmpty()) {
                IOUtils.copy(replaceable, writer);
            }
            Mustache.compiler().compile(replaceable).execute((Object)new MustacheContext((Map)((Object)values)), writer);
        }
        catch (MustacheException me) {
            throw new RuntimeException("Could not replace keys in " + replaceable, me);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static File createUniqueFileNameWithNewExtension(File source, File workingDir, String ext) {
        String name = IOUtils.extractFileNameWithoutExtension(source);
        String newFileName = name + "." + ext;
        for (int i = 1; i < 50; ++i) {
            File newFile = new File(workingDir, newFileName);
            if (!newFile.exists()) {
                return newFile;
            }
            newFileName = name + i + "." + ext;
        }
        throw new RuntimeException("Cannot generate unique file name for '" + name + "." + ext + "' in directory " + workingDir.getAbsolutePath());
    }

    public static File createFileNameWithNewExtension(File source, File workingDir, String ext) {
        String name = IOUtils.extractFileNameWithoutExtension(source);
        String newFileName = name + "." + ext;
        File newFile = new File(workingDir, newFileName);
        if (newFile.exists()) {
            newFile.delete();
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeIOException();
            }
        }
        return newFile;
    }

    public static String extractFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index > -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String extractFileName(URL url) {
        String urlAsString = url.toString();
        if (urlAsString.endsWith("/")) {
            urlAsString = urlAsString.substring(0, urlAsString.length() - 1);
        }
        int slashIndex = urlAsString.lastIndexOf(47);
        return urlAsString.substring(slashIndex + 1);
    }

    public static String extractFileNameExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > -1) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static File explodeArchive(File archive, File explodedFolder) {
        try {
            zipEntryStream = new ZipInputStream(new FileInputStream(archive));
            if (!explodedFolder.exists()) {
                explodedFolder.mkdir();
            }
            while (true) lbl-1000:
            // 5 sources

            {
                if ((entry = zipEntryStream.getNextEntry()) == null) {
                    return explodedFolder;
                }
                try {
                    if (entry.isDirectory()) {
                        file = new File(explodedFolder, entry.getName());
                        if (file.exists()) ** GOTO lbl-1000
                        IOUtils.isTrue(file.mkdirs(), "Could not create directory: " + entry.getName());
                    }
                    destinationFile = new File(explodedFolder, entry.getName());
                    parentDirPath = destinationFile.getParent();
                    if (parentDirPath != null && !(destinationDir = new File(parentDirPath)).exists()) {
                        IOUtils.isTrue(destinationDir.mkdirs(), "Could not create directory: " + entry.getName());
                    }
                    if (!destinationFile.exists()) {
                        IOUtils.isTrue(destinationFile.createNewFile(), "Could not create file: " + entry.getName());
                    }
                    ByteStreams.copy((InputStream)zipEntryStream, (OutputStream)new FileOutputStream(destinationFile));
                }
                finally {
                    zipEntryStream.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException exc) {
            try {
                IOUtils.deleteRecursively(explodedFolder);
            }
            catch (Exception e) {
                IOUtils.logger.error("Could not delete {}", (Object)explodedFolder, (Object)e);
            }
            throw new RuntimeIOException((Throwable)exc);
        }
        ** GOTO lbl-1000
    }

    public static boolean deleteRecursively(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && IOUtils.deleteRecursively(f);
            }
        }
        return ret && path.delete();
    }

    private static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    private static class MustacheContext
    extends ForwardingMap<String, Object> {
        private Map<String, Object> delegate = Maps.newHashMap();

        private MustacheContext(Map<String, Object> delegate) {
            this.delegate = delegate;
        }

        protected Map<String, Object> delegate() {
            return this.delegate;
        }

        public Object get(Object key) {
            if (this.delegate.containsKey(key)) {
                return this.delegate.get(key);
            }
            String prefix = key + ".";
            HashMap map = Maps.newHashMap();
            for (String fullKey : this.delegate.keySet()) {
                if (fullKey.startsWith(prefix)) {
                    map.put(fullKey.substring(prefix.length()), this.delegate.get(fullKey));
                }
                if (map.isEmpty()) continue;
                return new MustacheContext(map);
            }
            return null;
        }
    }
}

