/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;

public class ArchivedTaskWriter extends TaskWithBlockWriter {
    @Override protected void writePhaseContainer(HierarchicalStreamWriter writer, MarshallingContext context, BlockState block) {
        writer.startNode("block");
        Converters.writePhaseContainer((PhaseContainerState) block, writer, context, true);
        writer.endNode();
    }
}
