package com.xebialabs.xltype.serialization.jdom;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;

import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.joda.time.DateTime;

public class JdomWriter {

    private final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();

    private Document document;
    private Deque<Element> elementStack = new ArrayDeque<>();

    public JdomWriter() {
        this.document = new Document();
    }

    public JdomWriter element(String name) {
        return element(name, null);
    }

    public JdomWriter element(String name, Namespace namespace) {
        Element e = new Element(name, namespace);
        if (elementStack.isEmpty()) {
            document.addContent(e);
        } else {
            elementStack.peek().addContent(e);
        }
        elementStack.push(e);
        return this;
    }

    public JdomWriter endElement() {
        elementStack.pop();
        return this;
    }

    public JdomWriter attribute(String name, String value) {
        elementStack.peek().setAttribute(name, value);
        return this;
    }

    public JdomWriter attributeAsDate(String name, DateTime date) {
        attribute(name, dateTimeAdapter.marshal(date));
        return this;
    }

    public JdomWriter value(String value) {
        elementStack.peek().setText(value);
        return this;
    }

    public JdomWriter valueAsDate(DateTime date) {
        this.value(dateTimeAdapter.marshal(date));
        return this;
    }

    @Override
    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(document, stringWriter);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }
}
