/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.jdom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JdomWriter {
    private Document document;
    private Deque<Element> elementStack = new ArrayDeque<Element>();

    public JdomWriter() {
        this.document = new Document();
    }

    public JdomWriter element(String name) {
        Element e = new Element(name);
        if (this.elementStack.isEmpty()) {
            this.document.addContent((Content)e);
        } else {
            this.elementStack.peek().addContent((Content)e);
        }
        this.elementStack.push(e);
        return this;
    }

    public JdomWriter endElement() {
        this.elementStack.pop();
        return this;
    }

    public JdomWriter attribute(String name, String value) {
        this.elementStack.peek().setAttribute(name, value);
        return this;
    }

    public JdomWriter value(String value) {
        this.elementStack.peek().setText(value);
        return this;
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(this.document, (Writer)stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }
}

