/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;

public class TaskPreviewBlockJsonConverter {

    private final BlockStateJsonConverter blockStateJsonConverter = new BlockStateJsonConverter();

    public JsonWriter writeJsonObject(TaskPreviewBlock taskPreviewBlock, JsonWriter writer) {
        writer.object();

        writer.key("id").value(taskPreviewBlock.getId());

        if (taskPreviewBlock.getBlock() != null) {
            writer.key("block");
            blockStateJsonConverter.writeJsonObject(taskPreviewBlock.getBlock(), writer);
        }

        writer.endObject();

        return writer;
    }
}

