/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.*;

public class Converters {

    public static void checkArgument(boolean expression, String message, Object... params) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, params));
        }
    }

    public static JsonWriter writePhaseContainer(PhaseContainerState phaseContainerState, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("root").value("true");

        Iterable<PhaseState> blocks = phaseContainerState.getBlocks();
        if (blocks.iterator().hasNext()) {
            writer.key("blocks").array();
            for (PhaseState phase : blocks) {
                writer.object();
                writePhase(phase, writer, writeStepBlocks);
                writer.endObject();
            }
            writer.endArray();
        }
        return writer;
    }

    public static JsonWriter writePhase(PhaseState phase, JsonWriter writer, boolean writeStepBlocks) {
        writeBlockBasics(phase, writer);
        writer.key("phase").value("true");
        writer.key("block");
        writeBlockTree(phase.getBlock(), writer, writeStepBlocks);
        return writer;
    }

    public static JsonWriter writeBlockBasics(BlockState block, JsonWriter writer) {
        writer.key("id").value(block.getId() == null ? "" : block.getId());
        writer.key("state").value(block.getState() == null ? null : block.getState().toString());
        writer.key("description").value(block.getDescription());
        writer.key("hasSteps").value(block.hasSteps());
        if (block.getSatelliteConnectionState() != null) {
            writer.key("satelliteConnectionState").value(block.getSatelliteConnectionState().toString());
        }

        return writer;
    }

    public static JsonWriter writeBlockTree(BlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.object();
        writeBlockBasics(block, writer);
        if (block instanceof CompositeBlockState) {
            writeCompositeBlockState((CompositeBlockState) block, writer, writeStepBlocks);
        } else if (block instanceof StepBlockState) {
            writeStepBlockState((StepBlockState) block, writer, writeStepBlocks);
        } else if (block instanceof PhaseContainerState) {
            writePhaseContainer((PhaseContainerState) block, writer, writeStepBlocks);
        }
        writer.endObject();
        return writer;
    }

    public static JsonWriter writeCompositeBlockState(CompositeBlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("parallel").value(block.isParallel());

        if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
            writer.key("blocks").array();
            for (BlockState blockChild : block.getBlocks()) {
                writeBlockTree(blockChild, writer, writeStepBlocks);
            }
            writer.endArray();
        }
        return writer;
    }

    public static JsonWriter writeStepBlockState(StepBlockState block, JsonWriter writer, boolean writeStepBlocks) {
        writer.key("currentStep").value(block.getCurrentStep());

        if (writeStepBlocks && block.getSteps() != null && !block.getSteps().isEmpty()) {
            StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();
            writer.key("steps").array();
            for (StepState stepState : block.getSteps()) {
                stepStateJsonConverter.writeJsonObject(stepState, writer);
            }
            writer.endArray();
        }
        return writer;
    }
}