/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.util;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReference;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReferenceUtils {

    /**
     * Resolve all ciReferences by first looking up in ciMap and then querying repository
     *
     * @param references - list of ci references
     * @param ciMap      - map of cis (context). May potentially be not persisted yet
     * @param repository - ci repository instance
     */
    public static void resolveReferences(List<CiReference> references,
                                         Map<String, ConfigurationItem> ciMap,
                                         Repository repository) {
        references.forEach((reference) -> {
            List<ConfigurationItem> resolvedCIs = reference.getIds().stream().map((id) -> {
                ConfigurationItem fromContext = ciMap.get(id);
                if (fromContext != null) {
                    return fromContext;
                } else {
                    return repository.read(id);
                }
            }).collect(Collectors.toList());
            reference.set(resolvedCIs);
        });
    }
}
