/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream

import com.thoughtworks.xstream.converters.{Converter, MarshallingContext, UnmarshallingContext}
import com.thoughtworks.xstream.io.{HierarchicalStreamReader, HierarchicalStreamWriter}
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus

@XStreamProvider(readable = classOf[TaskPathStatus], tagName = "taskPathStatus")
class TaskPathStatusWriter extends Converter {
  override def marshal(source: Any, writer: HierarchicalStreamWriter, context: MarshallingContext): Unit = {
    val taskPathStatus = source.asInstanceOf[TaskPathStatus]
    writer.addAttribute("taskId", taskPathStatus.taskId)
    writer.addAttribute("path", taskPathStatus.path)
    writer.addAttribute("status", taskPathStatus.status)
  }

  override def unmarshal(reader: HierarchicalStreamReader, context: UnmarshallingContext): AnyRef = {
    val taskId = reader.getAttribute("taskId")
    val path = reader.getAttribute("path")
    val status = reader.getAttribute("status")
    TaskPathStatus(taskId, path, status)
  }

  override def canConvert(`type`: Class[_]): Boolean = classOf[TaskPathStatus].isAssignableFrom(`type`)
}
