/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.xltype.serialization.xstream.Converters.writeConfigurationItem;


public class ConfigurationItemCollectionConverter extends CollectionConverter {

    public ConfigurationItemCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (item instanceof ConfigurationItem) {
            writeConfigurationItem((ConfigurationItem) item, writer, context);
        } else {
            super.writeItem(item, context, writer);
        }

    }
}
