/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.rest;

import jakarta.ws.rs.ext.ParamConverter;
import org.joda.time.DateTime;

import com.xebialabs.xltype.serialization.util.DateUtil;

public class DateTimeParamConverter implements ParamConverter<DateTime> {

    @Override
    public DateTime fromString(String rfc822DateFormat) {
        return DateUtil.fromString(rfc822DateFormat);
    }

    @Override
    public String toString(DateTime value) {
        return DateUtil.toString(value);
    }

}
