package com.xebialabs.deployit.engine.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.engine.xml.Converters.writeNode;

public abstract class AbstractTaskConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskState t = (TaskState) source;
        writer.addAttribute("id", t.getId());
        writer.addAttribute("currentStep", Integer.toString(t.getCurrentStepNr()));
        writer.addAttribute("totalSteps", Integer.toString(t.getNrSteps()));
        writer.addAttribute("failures", Integer.toString(t.getFailureCount()));
        writer.addAttribute("state", t.getState().name());
        writer.addAttribute("owner", t.getOwner());

        writeNode("description", t.getDescription(), writer);

        if (t.getStartDate() != null) {
            writeNode("startDate", new DateTimeAdapter().marshal(t.getStartDate()), writer);
        }
        if (t.getCompletionDate() != null) {
            writeNode("completionDate", new DateTimeAdapter().marshal(t.getCompletionDate()), writer);
        }

        Map<String, String> metadata = t.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            writeNode(e.getKey(), e.getValue(), writer);
        }
        writer.endNode();

        if (t instanceof TaskWithSteps) {
            writeSteps(writer, context, (TaskWithSteps) t);
        }

    }

    private void writeSteps(HierarchicalStreamWriter writer, MarshallingContext context, TaskWithSteps t) {
        List<StepState> steps = ((TaskWithSteps) t).getSteps();
        writer.startNode("steps");
        for (StepState step : steps) {
            writer.startNode("step");
            context.convertAnother(step);
            writer.endNode();
        }
        writer.endNode();
    }

    @Override
    public boolean canConvert(Class type) {
        return TaskState.class.isAssignableFrom(type);
    }
}
