package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class Converters {

    public static <T> List<T> readList(Object owner, Class<T> toRead, HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<T> list = newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add((T) context.convertAnother(owner, toRead));
            reader.moveUp();
        }
        return list;
    }

    public static void writeNode(String name, String value, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        if (value != null) {
            writer.setValue(value);
        }
        writer.endNode();
    }

    public static void writeConfigurationItem(ConfigurationItem ci, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode(ci.getType().toString());
        context.convertAnother(ci);
        writer.endNode();
    }


}
