/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DeploymentInfoJsonConverter {
    private DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public String toJson(DeploymentInfo deploymentInfo) {
        JsonWriter writer = new JsonWriter();
        this.toJson(deploymentInfo, writer);
        return writer.toString();
    }

    public void toJson(DeploymentInfo deploymentInfo, JsonWriter writer) {
        writer.object();
        writer.key("id").value(deploymentInfo.getId());
        DateTime lastDeploymentDate = deploymentInfo.getLastDeploymentDate();
        writer.key("lastDeploymentDate").value(lastDeploymentDate == null ? null : this.FORMATTER.print((ReadableInstant)deploymentInfo.getLastDeploymentDate()));
        writer.key("lastDeploymentBy").value(deploymentInfo.getLastDeploymentBy());
        writer.key("type").value(deploymentInfo.getType());
        writer.endObject();
    }

    public DeploymentInfo toDeploymentInfo(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            Checks.checkArgument((boolean)json.has("id"), (String)"Missing 'id' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            Checks.checkArgument((boolean)json.has("lastDeploymentDate"), (String)"Missing 'lastDeploymentDate' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            Checks.checkArgument((boolean)json.has("lastDeploymentBy"), (String)"Missing 'lastDeploymentBy' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            Checks.checkArgument((boolean)json.has("type"), (String)"Missing 'type' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            return new DeploymentInfo(json.getString("id"), Type.valueOf((String)json.getString("type")), DateTime.parse((String)json.getString("lastDeploymentDate"), (DateTimeFormatter)this.FORMATTER), json.getString("lastDeploymentBy"));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}

