/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.packager.truezip;

import java.io.*;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;

import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import de.schlichtherle.truezip.file.*;

public class TFiles {
    public static ByteSource newByteSource(final TFile file) {
        return new ByteSource() {
            @Override
            public InputStream openStream() throws IOException {
                return new TFileInputStream(file);
            }
        };
    }

    public static CharSource newCharSource(final TFile file, final CharsetDecoder decoder) {
        return new CharSource() {
            @Override
            public Reader openStream() throws IOException {
                return new TFileReader(file, decoder);
            }
        };
    }

    public static ByteSink newByteSink(final TFile file) {
        return new ByteSink() {
            @Override
            public OutputStream openStream() throws IOException {
                return new TFileOutputStream(file);
            }
        };
    }

    public static CharSink newCharSink(final TFile file, final boolean append, final CharsetEncoder encoder) {
        return new CharSink() {
            @Override
            public Writer openStream() throws IOException {
                return new TFileWriter(file, append, encoder);
            }
        };
    }
}
