/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.packager;

import com.xebialabs.deployit.engine.packager.content.DarContents;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;

public class DarPackager {
    private File targetDirectory;
    private DarContents darContents;

    public DarPackager(File targetDirectory, DarContents darContents) {
        this.targetDirectory = targetDirectory;
        this.darContents = darContents;
    }

    public File perform() {
        this.targetDirectory.mkdirs();
        TFile exportedDar = new TFile(this.targetDirectory, this.darContents.getPackageName());
        try {
            this.darContents.fillIn(exportedDar);
            File file = exportedDar.getFile();
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Errors found while exporting package version", e);
        }
        finally {
            try {
                TFile.umount((TFile)exportedDar);
            }
            catch (FsSyncException ignore) {}
        }
    }
}

