/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.packager.content;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.packager.content.DarContents;
import com.xebialabs.deployit.engine.packager.manifest.ManifestWriter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeployitDarContents
extends DarContents {
    private DeploymentPackage deploymentPackage;
    private ManifestWriter manifestWriter;
    private Map<String, String> artifactLookup;

    public DeployitDarContents(DeploymentPackage deploymentPackage, ManifestWriter manifestWriter) {
        this.deploymentPackage = deploymentPackage;
        this.manifestWriter = manifestWriter;
    }

    @Override
    public void fillIn(TFile dar) throws IOException {
        this.attachManifest(dar, this.createManifest(this.deploymentPackage));
        this.copyArtifactsToDar(this.deploymentPackage, dar);
    }

    @Override
    public String getPackageName() {
        return String.format("%s-%s.dar", this.deploymentPackage.getApplication().getName(), this.deploymentPackage.getVersion());
    }

    private ManifestWriter createManifest(DeploymentPackage deploymentPackage) {
        this.artifactLookup = this.createArtifactLookupTabel(deploymentPackage);
        this.manifestWriter.addHeader(deploymentPackage.getApplication().getName(), deploymentPackage.getVersion());
        Set deployables = deploymentPackage.getDeployables();
        for (ConfigurationItem each : deployables) {
            String baseId;
            Map<String, String> values = this.getPropertyValues(deploymentPackage, each);
            if (this.isMiddlewareResource(each)) {
                baseId = each.getName();
                this.manifestWriter.addResourceEntry(baseId, each.getType().toString(), values);
            } else {
                BaseDeployableArtifact artifact = (BaseDeployableArtifact)each;
                values.put("Name", each.getName());
                baseId = artifact.getFile().getName();
                this.manifestWriter.addArtifactEntry(baseId, each.getType().toString(), values);
            }
            this.writeEmbeddeds(deploymentPackage, this.manifestWriter, each, baseId);
        }
        return this.manifestWriter;
    }

    private Map<String, String> createArtifactLookupTabel(DeploymentPackage deploymentPackage) {
        HashMap map = Maps.newHashMap();
        Set deployables = deploymentPackage.getDeployables();
        String baseId = deploymentPackage.getId();
        for (ConfigurationItem deployable : deployables) {
            this.createArtifactLookupTable(map, deployable, baseId);
        }
        return map;
    }

    private void createArtifactLookupTable(Map<String, String> map, ConfigurationItem ci, String baseId) {
        String altId = baseId + "/";
        altId = this.isMiddlewareResource(ci) ? altId + ci.getName() : altId + ((DeployableArtifact)ci).getFile().getName();
        map.put(ci.getId(), altId);
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                Collection cis = (Collection)propertyDescriptor.get(ci);
                for (ConfigurationItem propertyCi : cis) {
                    this.createArtifactLookupTable(map, propertyCi, altId);
                }
                continue;
            }
            if (propertyDescriptor.getKind() != PropertyKind.CI) continue;
            this.createArtifactLookupTable(map, (ConfigurationItem)propertyDescriptor.get(ci), altId);
        }
    }

    private void writeEmbeddeds(DeploymentPackage deploymentPackage, ManifestWriter manifestWriter, ConfigurationItem ci, String baseId) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getKind() != PropertyKind.SET_OF_CI || !propertyDescriptor.getReferencedType().getDescriptor().isAssignableTo(EmbeddedDeployable.class)) continue;
            Collection embeddeds = (Collection)propertyDescriptor.get(ci);
            for (ConfigurationItem embedded : embeddeds) {
                Map<String, String> values = this.getPropertyValues(deploymentPackage, embedded);
                String entryName = baseId + "/" + embedded.getName();
                manifestWriter.addResourceEntry(entryName, embedded.getType().toString(), values);
                this.writeEmbeddeds(deploymentPackage, manifestWriter, embedded, entryName);
            }
        }
    }

    private void copyArtifactsToDar(DeploymentPackage deploymentPackage, TFile dar) throws IOException {
        for (Deployable each : deploymentPackage.getDeployables()) {
            if (this.isMiddlewareResource((ConfigurationItem)each)) continue;
            BaseDeployableArtifact artifact = (BaseDeployableArtifact)each;
            File srcArtifact = new File(artifact.getFile().getPath());
            TFile destArtifact = new TFile((File)dar, artifact.getFile().getName(), TArchiveDetector.NULL);
            TFile.cp_r((File)srcArtifact, (File)destArtifact, (TArchiveDetector)TArchiveDetector.NULL);
        }
    }

    private Map<String, String> getPropertyValues(DeploymentPackage deploymentPackage, ConfigurationItem ci) {
        HashMap valueMap = Maps.newHashMap();
        block7: for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            Object value;
            if (propertyDescriptor.isHidden() || "placeholders".equals(propertyDescriptor.getName()) || (value = propertyDescriptor.get(ci)) == null) continue;
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    valueMap.put(propertyDescriptor.getName(), String.valueOf(value));
                    break;
                }
                case CI: {
                    valueMap.put(propertyDescriptor.getName(), this.relativeReference(deploymentPackage, (ConfigurationItem)((BaseConfigurationItem)value)));
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    int strCount = 1;
                    for (String s : (Collection)value) {
                        valueMap.put(propertyDescriptor.getName() + "-EntryValue-" + strCount++, s);
                    }
                    continue block7;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    int ciCount = 1;
                    for (ConfigurationItem ciEntry : (Collection)value) {
                        valueMap.put(propertyDescriptor.getName() + "-EntryValue-" + ciCount++, this.relativeReference(deploymentPackage, ciEntry));
                    }
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        valueMap.put(propertyDescriptor.getName() + "-" + (String)entry.getKey(), entry.getValue());
                    }
                    break;
                }
            }
        }
        return valueMap;
    }

    private String relativeReference(DeploymentPackage deploymentPackage, ConfigurationItem ciEntry) {
        int offset = deploymentPackage.getId().length() + 1;
        String substitute = this.artifactLookup.get(ciEntry.getId());
        return substitute.substring(offset);
    }

    private boolean isMiddlewareResource(ConfigurationItem ci) {
        return !ci.getType().getDescriptor().isAssignableTo(DeployableArtifact.class);
    }
}

