package com.xebialabs.deployit.engine.packager.manifest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public interface ManifestWriter {

    void addHeader(String application, String version);

    void addResourceEntry(String entryName, String type, Map<String, String> values);

    void addArtifactEntry(String entryName, String type, Map<String, String> values);

    public void addArtifactEntry(String entryName, String type, Map<String, String> values, String ciName);

    /**
     * Supposed to be able to write same manifest to different streams as many times as needed.
     */
    <T extends OutputStream> T writeTo(final T stream) throws IOException;

}
