package com.xebialabs.deployit.engine.packager;

import java.io.File;

import com.xebialabs.deployit.engine.packager.content.DarContents;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;


/**
 * Responsible for creating and closing a dar file. Content generation is delegated to content holders.
 */
public class DarPackager {

    private File targetDirectory;

    private DarContents darContents;

    public DarPackager(File targetDirectory, DarContents darContents) {
        this.targetDirectory = targetDirectory;
        this.darContents = darContents;
    }

    public File perform() {
        targetDirectory.mkdirs();
        TFile exportedDar = new TFile(targetDirectory, darContents.getPackageName());
        try {
            darContents.fillIn(exportedDar);
            return exportedDar.getFile();
        } catch (Exception e) {
            throw new RuntimeException("Errors found while exporting package version", e);
        } finally {
            try {
                TFile.umount(exportedDar);
            } catch (FsSyncException ignore) {}
        }
    }

}
