package com.xebialabs.deployit.engine.packager.content;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

/**
 * Some dar package member
 */
public class DarMember implements Serializable {

    protected String name;
    protected String type;
    protected File location;
    protected String entryName;
    protected final Map<String, String> values = newHashMap();

    protected final List<String> tags = newArrayList();

    public DarMember() {}

    public DarMember(String name, String type) {
        this(name, type, null);
    }

    public DarMember(String name, String type, File location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getValues() {
        return values;
    }

    public File getLocation() {
        return location;
    }

    public void setLocation(File location) {
        this.location = location;
        if (entryName == null)
            entryName = location.getName();
    }

    public String getEntryName() {
        if (isNullOrEmpty(entryName)) {
            this.entryName = (getLocation() == null ? name : getLocation().getName());
        }
        return entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public List<String> getTags() {
        return tags;
    }

    public void addTag(String tag) {
        tags.add(tag);
    }

    @Override
    public String toString() {
        return "Deployable{" +
                "location=" + location +
                ", name='" + name + '\'' +
                ", tags=" + tags +
                ", type='" + type + '\'' +
                ", values=" + values +
                '}';
    }
}
