package com.xebialabs.deployit.packager;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;

/**
 * Writes a manifest file for inclusion in a Deployment Package (Dar file).
 */
public interface ManifestWriter {

    String getManifestFileName();

    /**
     * Writes the deployment package information to the manifest file.
     *
     * @param type The type of the deployment package
     * @param version The version of the application that this package comprises.
     * @param application The application name.
     */
    ManifestCiWriter writeVersion(Type type, String version, String application);

    /**
     * Finishes writing the manifest.
     */
    void endManifest();

    /**
     * Add a {@link Deployable} configuration item to the manifest.
     *
     * @param name the name of the CI
     * @param type the type of the CI
     * @return A new {@link ManifestCiWriter} that can be used to write the properties to the manifest.
     */
    ManifestCiWriter writeCi(String name, Type type);

    /**
     * Add a {@link Deployable} configuration item to the manifest.
     *
     * @param name the name of the CI
     * @param type the type of the CI
     * @param fileArtifact the file associated with the artifact
     * @return A new {@link ManifestCiWriter} that can be used to write the properties to the manifest.
     */
    ManifestCiWriter writeCi(String name, Type type, String fileArtifact);

    public interface ManifestCiWriter {
        void property(String propertyName);
        void writeAsStringValue(String value);
        void writeCiReferenceProperty(String ref);
        void writeStringCollectionProperty(List<String> values);
        void writeCiReferenceCollectionProperty(List<String> values);
        void writeMapStringStringProperty(Map<String, String> values);
        void endProperty();
        /**
         * Finishes writing a CI to the manifest.
         */
        ManifestWriter endCi();
    }
}
