package com.xebialabs.deployit.engine.tasker

import akka.actor._
import com.typesafe.config.{ConfigFactory, Config}
import java.io.File

class TaskerSettings(config: Config) extends Extension {
  val recoveryDir = new File(config.getString("deployit.task.recovery-dir"))
  val tickDuration = config.getMilliseconds("akka.scheduler.tick-duration")
}

object TaskerSettings extends ExtensionId[TaskerSettings] with ExtensionIdProvider {

  override def lookup = TaskerSettings

  override def createExtension(system: ExtendedActorSystem) =
    new TaskerSettings(ConfigFactory.load("tasker").withFallback(system.settings.config))

  /**
   * Java API: retrieve the Settings extension for the given system.
   */
  override def get(system: ActorSystem): TaskerSettings = super.get(system)
}
