package com.xebialabs.deployit.engine.tasker;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class TaskSpecification implements Serializable {
    private final String description;
    private final String owner;
    private final Block block;
    private final Map<String, String> metadata = newHashMap();
    private final List<ExecutionStateListener> listeners = newArrayList();
    private final File tempWorkDir;
    private final String id;
    private TaskInspectionContext inspectionContext;
    private boolean recoverable;
    private boolean archiveable;

    public TaskSpecification(String description, String owner, Block block) {
        this(description, owner, block, null);
    }

    public TaskSpecification(String description, String owner, Block block, TaskInspectionContext inspectionContext) {
        this(description, owner, block, inspectionContext, true);
    }

    public TaskSpecification(String description, String owner, Block block, TaskInspectionContext inspectionContext, boolean recoverable) {
        this(description, owner, block, inspectionContext, null, recoverable, true);
    }

    public TaskSpecification(String description, String owner, Block block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(description, owner, block, inspectionContext, null, recoverable, archiveable);
    }

    public TaskSpecification(String description, String owner, Block block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable) {
        this(UUID.randomUUID().toString(), description, owner, block, inspectionContext, tempWorkDir, recoverable, archiveable);
    }

    public TaskSpecification(String id, String description, String owner, Block block, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable, boolean archiveable) {
        this.id = id;
        this.description = description;
        this.owner = owner;
        this.block = block;
        this.inspectionContext = inspectionContext;
        this.tempWorkDir = tempWorkDir;
        this.recoverable = recoverable;
        this.archiveable = archiveable;

    }

    public String getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }

    // Ugly casting ;-)
    public List<TaskStep> getSteps() {
        return (List<TaskStep>) ((List) block.getStepList());
    }

    public Block getBlock() {
        return block;
    }

    public String getOwner() {
        return owner;
    }

    public Map<String, String> getMetadata() {
        return metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return inspectionContext;
    }

    public File getTempWorkDir() {
        return tempWorkDir;
    }

    public boolean isRecoverable() {
        return recoverable;
    }

    public boolean isArchiveable() {
        return archiveable;
    }
}
