package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;

import com.xebialabs.deployit.plugin.api.flow.Step;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.sort;

class StepPlan {

    ListMultimap<Integer, Step> stepsMap = ArrayListMultimap.create();

    void add(Step step) {
        stepsMap.put(step.getOrder(), step);
    }

    void addAll(Collection<Step> steps) {
        for (Step step : steps) {
            add(step);
        }
    }

    List<Step> getOrderedSteps() {
        List<Integer> keys = newArrayList();
        List<Step> steps = newArrayList();
        keys.addAll(stepsMap.keySet());
        sort(keys);
        for (Integer key : keys) {
            steps.addAll(stepsMap.get(key));
        }

        return steps;
    }
}
