/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Set;

public class Plan {
    private List<StepWithDelta> steps = Lists.newArrayList();
    private List<Checkpoint> checkpoints = Lists.newArrayList();
    private List<ExecutionStateListener> listeners = Lists.newArrayList();

    public List<Step> getSteps() {
        return Lists.newArrayList((Iterable)Lists.transform(this.steps, (Function)new Function<StepWithDelta, Step>(){

            public Step apply(StepWithDelta input) {
                return input.step;
            }
        }));
    }

    public List<StepWithDelta> getStepsWithDelta() {
        return this.steps;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public List<ExecutionStateListener> getListeners() {
        return this.listeners;
    }

    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        ArrayListMultimap checkpointsByStep = ArrayListMultimap.create();
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpointsByStep.put((Object)checkpoint.getStep(), (Object)checkpoint);
        }
        int index = 0;
        for (StepWithDelta swo : this.steps) {
            out.format("%2s. (%3s) - %s  (%s)\n", ++index, swo.step.getOrder(), swo.step.getDescription(), swo.getClass().getSimpleName());
            if (!checkpointsByStep.containsKey((Object)swo.step)) continue;
            for (Checkpoint checkpoint : checkpointsByStep.get((Object)swo.step)) {
                out.format("            *checkpoint*  %s\n", checkpoint);
            }
        }
        return writer;
    }

    public static class Checkpoint
    implements Serializable {
        private Delta delta;
        private Operation operation;
        private Step step;

        public Checkpoint(Delta delta, Step step) {
            this(delta, step, delta.getOperation());
        }

        public Checkpoint(Delta delta, Step step, Operation operation) {
            this.delta = delta;
            this.step = step;
            this.operation = operation;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public Step getStep() {
            return this.step;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            switch (this.operation) {
                case CREATE: {
                    return String.format("%s %s", this.operation, this.delta.getDeployed());
                }
                case MODIFY: {
                    return String.format("%s from %s to %s", this.operation, this.delta.getPrevious(), this.delta.getDeployed());
                }
                case DESTROY: {
                    return String.format("%s %s", this.operation, this.delta.getPrevious());
                }
            }
            return this.operation.toString();
        }
    }

    public static class StepWithDelta {
        private Set<Delta> deltas = Sets.newHashSet();
        private Step step;

        public StepWithDelta(Step step, Delta delta) {
            if (delta != null) {
                this.deltas.add(delta);
            }
            this.step = step;
        }

        public StepWithDelta(Step step, Set<Delta> deltas) {
            this.deltas.addAll(deltas);
            this.step = step;
        }

        public Set<Delta> getDeltas() {
            return this.deltas;
        }

        public Step getStep() {
            return this.step;
        }
    }
}

