package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.flow.Step;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.sort;

class StepPlan {

    ListMultimap<Integer, Plan.StepWithDelta> stepsMap = ArrayListMultimap.create();

    private Delta deltaUnderPlanning;

    void setDeltaUnderPlanning(Delta delta) {
        deltaUnderPlanning = delta;
    }

    void add(Step step) {
        stepsMap.put(step.getOrder(), new Plan.StepWithDelta(step, deltaUnderPlanning));
    }

    void addAll(Collection<Step> steps) {
        for (Step step : steps) {
            add(step);
        }
    }

    List<Plan.StepWithDelta> getOrderedSteps() {
        List<Integer> keys = newArrayList();
        List<Plan.StepWithDelta> steps = newArrayList();
        keys.addAll(stepsMap.keySet());
        sort(keys);
        for (Integer key : keys) {
            steps.addAll(stepsMap.get(key));
        }

        return steps;
    }

    void clear() {
        stepsMap.clear();
    }
}
