package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.Multimaps;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Iterables.transform;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Multimaps.index;
import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.interleaved;
import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.serial;

@Orchestrator.Metadata(name = "container-by-container-serial")
public class ContainerByContainerOrchestrator implements Orchestrator {
    @Override
    public Orchestration orchestrate(DeltaSpecification specification) {
        List<Delta> deltas = specification.getDeltas();
        Function<Delta, Container> deltaToContainer = new Function<Delta, Container>() {
            public Container apply(Delta input) {
                return getDeployed(input).getContainer();
            }
        };
        Function<Collection<Delta>, Orchestration> deltasToPlan = new Function<Collection<Delta>, Orchestration>() {
            public Orchestration apply(Collection<Delta> input) {
                return interleaved(newArrayList(input));
            }
        };
        return serial(newArrayList(transform(index(deltas, deltaToContainer).asMap().values(), deltasToPlan)));
    }

    private Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}
