/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.orchestrator.OrchestratorRegistry;
import com.xebialabs.deployit.deployment.planner.DefaultDeploymentPlanningContext;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.orchestration.InterleavedOrchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.engine.spi.orchestration.ParallelOrchestration;
import com.xebialabs.deployit.engine.spi.orchestration.SerialOrchestration;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentPlanner
implements Planner {
    private Set<Method> contributors;
    private ListMultimap<Operation, Method> typeContributors;
    private List<Method> preProcessors;
    private List<Method> postProcessors;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentPlanner.class);

    private DeploymentPlanner() {
    }

    @Override
    public Plan plan(DeltaSpecification spec, Repository repository) {
        Orchestration orchestration = this.orchestrate(spec);
        Plan plan = new Plan();
        plan.getStepsWithDelta().addAll(this.preProcessPlan(spec).getOrderedSteps());
        plan.getStepsWithDelta().addAll(this.resolvePlan(orchestration, new DefaultDeploymentPlanningContext(spec.getDeployedApplication(), repository, plan)));
        plan.getStepsWithDelta().addAll(this.postProcessPlan(spec).getOrderedSteps());
        return plan;
    }

    private StepPlan postProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.postProcessors);
    }

    private StepPlan preProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.preProcessors);
    }

    private StepPlan processPlan(DeltaSpecification spec, List<Method> processors) {
        StepPlan steps = new StepPlan();
        for (Method processor : processors) {
            try {
                Object o = processor.getDeclaringClass().newInstance();
                this.addResultingStepToCollector(processor.invoke(o, spec), steps, processor);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }
        return steps;
    }

    private List<Plan.StepWithDelta> resolvePlan(Orchestration orchestration, DefaultDeploymentPlanningContext context) {
        if (orchestration instanceof ParallelOrchestration) {
            return this.resolveParallelPlan((ParallelOrchestration)orchestration, context);
        }
        if (orchestration instanceof SerialOrchestration) {
            return this.resolveSerialPlan((SerialOrchestration)orchestration, context);
        }
        this.orderedResolution((InterleavedOrchestration)orchestration, context);
        return context.planningResult.getOrderedSteps();
    }

    private List<Plan.StepWithDelta> resolveSerialPlan(SerialOrchestration orchestration, DefaultDeploymentPlanningContext context) {
        return this.resolvePlans(orchestration.getPlans(), context);
    }

    private List<Plan.StepWithDelta> resolveParallelPlan(ParallelOrchestration orchestration, DefaultDeploymentPlanningContext context) {
        return this.resolvePlans(orchestration.getPlans(), context);
    }

    private List<Plan.StepWithDelta> resolvePlans(List<Orchestration> orchestrations, DefaultDeploymentPlanningContext context) {
        ArrayList resolvedPlans = Lists.newArrayList();
        for (Orchestration subplan : orchestrations) {
            resolvedPlans.addAll(this.resolvePlan(subplan, context));
        }
        return resolvedPlans;
    }

    private Orchestration orchestrate(DeltaSpecification spec) {
        String orchestratorName = spec.getDeployedApplication().getOrchestrator();
        Orchestrator orchestrator = OrchestratorRegistry.getOrchestrator(orchestratorName);
        Preconditions.checkNotNull((Object)orchestrator, (String)"Could not find a registered orchestrator with name [%s]", (Object[])new Object[]{orchestratorName});
        return orchestrator.orchestrate(spec);
    }

    private void orderedResolution(InterleavedOrchestration orchestration, DefaultDeploymentPlanningContext context) {
        context.clear();
        this.callTypeContributors(this.typeContributors, orchestration, context);
        this.callContributors(this.contributors, orchestration, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callTypeContributors(ListMultimap<Operation, Method> typeContributors, InterleavedOrchestration plan, DefaultDeploymentPlanningContext context) {
        if (typeContributors == null) {
            return;
        }
        for (Delta dOp : plan.getDeltas()) {
            try {
                context.planningResult.setDeltaUnderPlanning(dOp);
                List methods = typeContributors.get((Object)dOp.getOperation());
                Deployed<?, ?> deployed = this.getActiveDeployed(dOp);
                for (Method method : methods) {
                    Type methodType = Type.valueOf(method.getDeclaringClass());
                    if (!deployed.getType().instanceOf(methodType)) continue;
                    this.invokeTypeContributer(context, dOp, method);
                }
            }
            finally {
                context.planningResult.setDeltaUnderPlanning(null);
            }
        }
    }

    private void callContributors(Set<Method> methods, InterleavedOrchestration plan, DeploymentPlanningContext context) {
        if (methods == null) {
            return;
        }
        Deltas deltas = new Deltas(plan.getDeltas());
        for (Method method : methods) {
            try {
                logger.trace("Invoking Contributor [{}] for [{}]", (Object)method, (Object)plan.getDeltas());
                Object contributorInstance = method.getDeclaringClass().newInstance();
                method.invoke(contributorInstance, deltas, context);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }
    }

    private Deployed<?, ?> getActiveDeployed(Delta dOp) {
        if (dOp.getOperation() == Operation.DESTROY) {
            return dOp.getPrevious();
        }
        return dOp.getDeployed();
    }

    private void invokeTypeContributer(DeploymentPlanningContext planContext, Delta delta, Method method) {
        logger.trace("Invoking Type Contributor [{}.{}] for [{}]", new Object[]{Type.valueOf(method.getDeclaringClass()), method.getName(), delta});
        try {
            if (method.getParameterTypes().length == 2) {
                method.invoke(this.getActiveDeployed(delta), planContext, delta);
            } else {
                method.invoke(this.getActiveDeployed(delta), planContext);
            }
        }
        catch (IllegalAccessException e) {
            throw new PlannerException(e);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e);
        }
    }

    private PlannerException handleInvocationTargetException(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            return new PlannerException(cause);
        }
        return new PlannerException(e);
    }

    private void addResultingStepToCollector(Object result, StepPlan steps, Method method) {
        if (result == null) {
            return;
        }
        if (result instanceof List) {
            steps.addAll(Collections2.transform((Collection)((List)result), (Function)new Function<Object, Step>(){

                public Step apply(Object input) {
                    return StepAdapter.wrapIfNeeded(input);
                }
            }));
        } else {
            steps.add(StepAdapter.wrapIfNeeded(result));
        }
    }

    public static class PlannerException
    extends RuntimeException {
        public PlannerException() {
        }

        public PlannerException(String message) {
            super(message);
        }

        public PlannerException(String message, Object ... params) {
            super(String.format(message, params));
        }

        public PlannerException(String message, Throwable cause) {
            super(message, cause);
        }

        public PlannerException(Throwable cause) {
            super(cause);
        }
    }

    public static class DeploymentPlannerBuilder {
        private DeploymentPlanner planner = new DeploymentPlanner();

        public DeploymentPlannerBuilder typeContributors(ListMultimap<Operation, Method> typeContributors) {
            this.planner.typeContributors = typeContributors;
            return this;
        }

        public DeploymentPlannerBuilder contributors(Set<Method> contributors) {
            this.planner.contributors = contributors;
            return this;
        }

        public DeploymentPlannerBuilder preProcessors(List<Method> preProcessors) {
            this.planner.preProcessors = preProcessors;
            return this;
        }

        public DeploymentPlannerBuilder postProcessors(List<Method> postProcessors) {
            this.planner.postProcessors = postProcessors;
            return this;
        }

        public DeploymentPlanner build() {
            return this.planner;
        }
    }
}

