package com.xebialabs.deployit.deployment.planner;

import java.io.Writer;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

public abstract class Plan {

    private List<ExecutionStateListener> listeners;

    protected Plan(final List<ExecutionStateListener> listeners) {
        this.listeners = listeners;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public abstract Writer writePlan(Writer writer);

    public abstract Set<StepPlan.Checkpoint> findCheckpoints();
}
