package com.xebialabs.deployit.deployment.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;

import static com.xebialabs.deployit.booter.local.utils.ReflectionUtils.handleInvocationTargetException;
import static com.xebialabs.deployit.plugin.api.Deprecations.deprecated;

public class ContributorInvokerRule extends OldRule<Deltas> {
    private Method contributor;

    public ContributorInvokerRule(Method contributor) {
        super(buildName(contributor), true);
        this.contributor = contributor;
    }

    private static String buildName(Method contributor) {
        return String.format("%s.%s", contributor.getDeclaringClass().getName(), contributor.getName());
    }

    public boolean canFire(Deltas deltas, DeploymentPlanningContext context) {
        return true;
    }

    @Override
    public void fire(Deltas deltas, DeploymentPlanningContext context) {
        try {
            if (Modifier.isStatic(contributor.getModifiers())) {
                contributor.invoke(null, deltas, context);
            } else {
                deprecated("Non-static contributors are considered deprecated, consider making [%s] static", contributor);
                Object contributorInstance = contributor.getDeclaringClass().newInstance();
                contributor.invoke(contributorInstance, deltas, context);
            }
        } catch (InstantiationException e) {
            throw new DeploymentPlanner.PlannerException(e);
        } catch (IllegalAccessException e) {
            throw new DeploymentPlanner.PlannerException(e);
        } catch (InvocationTargetException e) {
            throw handleInvocationTargetException(e, "");
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(ContributorInvokerRule.class);

}
