package com.xebialabs.deployit.deployment.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.rules.DeploymentRule;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static com.xebialabs.deployit.booter.local.utils.ReflectionUtils.handleInvocationTargetException;

@DeploymentRule("deployed")
public class DeployedInvokerRule extends OldRule<Delta> {

    private Type deployedType;

    private Operation operation;

    private Method method;

    public DeployedInvokerRule(Type deployedType, Method typeContributor, Operation operation) {
        super(buildName(deployedType, typeContributor, operation), true);
        this.deployedType = deployedType;
        this.method = typeContributor;
        this.operation = operation;
    }

    private static String buildName(Type deployedType, Method typeContributor, Operation operation) {
        // TODO optionally add operation if multiple annotations exist on the method, else do not add it
        return String.format("%s.%s_%s", deployedType, typeContributor.getName(), operation);
    }

    public boolean canFire(Delta delta, DeploymentPlanningContext context) {
        return delta.getOperation() == operation && getDeployed(delta).getType().instanceOf(deployedType);
    }

    public void fire(Delta delta, DeploymentPlanningContext context) {
        Deployed deployed = getDeployed(delta);
        try {
            if (method.getParameterTypes().length == 2) {
                method.invoke(deployed, context, delta);
            } else {
                method.invoke(deployed, context);
            }
        } catch (IllegalAccessException e) {
            throw new DeploymentPlanner.PlannerException(e);
        } catch (InvocationTargetException e) {
            throw handleInvocationTargetException(e, "");
        }
    }

    private Deployed getDeployed(Delta delta) {
        if (delta.getOperation() == Operation.DESTROY) {
            return delta.getPrevious();
        }

        return delta.getDeployed();
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployedInvokerRule.class);

}
