/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.rules.Rule;
import com.xebialabs.deployit.deployment.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class RuleStore {
    private static final AtomicReference<RuleStore> INSTANCE = new AtomicReference<RuleStore>(new RuleStore());
    private final Map<String, Class<? extends Step>> stepClassesByElement = Maps.newHashMap();
    private final Map<String, Class<? extends Step>> stepClassesByFunction = Maps.newHashMap();
    private final Map<String, Rule> rules = Maps.newHashMap();

    public static RuleStore getInstance() {
        return INSTANCE.get();
    }

    public void registerStepClass(Class<? extends Step> stepClass, StepMetadata stepMetadata) {
        if (this.stepClassesByElement.containsKey(stepMetadata.elementName())) {
            throw new IllegalArgumentException(String.format("Builder with duplicate element name [%s] found.", stepMetadata.elementName()));
        }
        if (this.stepClassesByFunction.containsKey(stepMetadata.functionName())) {
            throw new IllegalArgumentException(String.format("Builder with duplicate function name [%s] found.", stepMetadata.functionName()));
        }
        this.stepClassesByElement.put(stepMetadata.elementName(), stepClass);
        this.stepClassesByFunction.put(stepMetadata.functionName(), stepClass);
    }

    public void registerRule(Rule rule) {
        if (this.rules.containsKey(rule.getName())) {
            throw new IllegalArgumentException(String.format("Rule with duplicate name [%s] found.", rule.getName()));
        }
        this.rules.put(rule.getName(), rule);
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public Rule getRule(String ruleName) {
        return this.rules.get(ruleName);
    }

    public Collection<Class<? extends Step>> getStepClasses() {
        return this.stepClassesByElement.values();
    }

    public Class<? extends Step> getStepClassByElement(String elementName) {
        return this.stepClassesByElement.get(elementName);
    }

    public Class<? extends Step> getStepClassByFunction(String functionName) {
        return this.stepClassesByFunction.get(functionName);
    }
}

