package com.xebialabs.deployit.deployment.rules

import scala.xml.{Elem, Node}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation
import grizzled.slf4j.Logging

class RulesReader(val store: RuleStore) extends Logging {
  def fromXML(xml: Elem) {
    (xml \ "rule").foreach { node =>
      val name: String = (node \ "@name").text
      debug("Reading rule [" + name + "]")
      if (store.getRule(name) != null) throw new IllegalArgumentException("Cannot declare rule with name [%s] more than once".format(name))
      val scope: Scope = Scope.getScope((node \ "@scope").text)
      if((node \ "script").headOption.isDefined) {
        store.registerRule(parseScriptRuleDefinition(name, scope, node))
      } else if(scope != Scope.DEPLOYED) {
        store.registerRule(parseGlobalRuleDefinition(name, scope, node))
      } else {
        store.registerRule(parseDeployedRuleDefinition(name, scope, node))
      }
    }
    (xml \ "disable-rule").foreach { node =>
      val name: String = (node \ "@name").text
      debug("Disabling rule [" + name + "]")
      store.getRule(name) match {
        case rule: Rule => rule.disable()
        case _ => info("Encountered [disable-rule] for rule [" + name + "] which was not found.")
      }
    }

  }

  def parseScriptRuleDefinition(name: String, scope: Scope, node: Node):Rule = {
    val script = (node \ "script").text
    new ScriptRule(name, scope, script)
  }

  def parseGlobalRuleDefinition(name: String, scope: Scope, node: Node):Rule = {
    val conditions = parseConditions(node)
//    val steps = parseStepDefinitions(node)
    if((node \ "type").headOption.isDefined) throw new Exception("Global rule [%s] should not define type conditions".format(name))
    if((node \ "operation").headOption.isDefined) throw new Exception("Global rule [%s] should not define operation conditions".format(name))
//    new GlobalRuleDefinition(name, scope, conditions, steps)
    null
  }

  def parseDeployedRuleDefinition(name: String, scope: Scope, node: Node):Rule = {
    val types = (node \ "type").map(n => Type.valueOf(n.text))
    val operations = (node \ "operation").map(n => Operation.valueOf(n.text.toUpperCase))
    val conditions = parseConditions(node)
//    val steps = parseStepDefinitions(node)
//    new DeployedRuleDefinition(name, scope, types, operations, conditions, steps)
    null
  }

  def parseConditions(node: Node): Seq[String] = {
    (node \ "condition").map(n => n.text)
  }
//
//  def parseStepDefinitions(node: Node): Seq[StepDefinition] = {
//    (node \ "steps").headOption.map(h => h.child.collect({
//      case e: Elem => parseStepDefinition(e)
//    })).getOrElse(Seq())
//  }
//
//  def parseStepDefinition(node: Elem):StepDefinition = {
//    val stepBuilder = node.label
//    val stepParameters = node.child.collect({case e:Elem => (e.label, e.text)}).toMap
//    new StepDefinition(stepBuilder, stepParameters)
//  }

}
