/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.SimplifyingDeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.SizeChunkingPlanner;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.planning.PostPlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import nl.javadude.scannit.Scannit;

public class DeploymentPlannerFactory {
    public static final Comparator<Method> PROCESSOR_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method m1, Method m2) {
            int o2;
            int o1;
            String c1 = m1.getDeclaringClass().getSimpleName();
            String c2 = m2.getDeclaringClass().getSimpleName();
            if (m1.isAnnotationPresent(PrePlanProcessor.class)) {
                o1 = m1.getAnnotation(PrePlanProcessor.class).order();
                o2 = m2.getAnnotation(PrePlanProcessor.class).order();
            } else {
                o1 = m1.getAnnotation(PostPlanProcessor.class).order();
                o2 = m2.getAnnotation(PostPlanProcessor.class).order();
            }
            if (o1 != o2) {
                return Integer.valueOf(o1).compareTo(o2);
            }
            if (!c1.equals(c2)) {
                return c1.compareTo(c2);
            }
            return m1.getName().compareTo(m2.getName());
        }
    };

    public Planner planner() {
        ListMultimap<Operation, Method> deployedContributors = this.registerDeployedContributors();
        Set<Method> contributors = this.registerContributors();
        Scannit instance = Scannit.getInstance();
        List<Method> preProcessors = this.orderProcessors(this.checkProcessors(instance.getMethodsAnnotatedWith(PrePlanProcessor.class)));
        List<Method> postProcessors = this.orderProcessors(this.checkProcessors(instance.getMethodsAnnotatedWith(PostPlanProcessor.class)));
        return new SizeChunkingPlanner(new SimplifyingDeploymentPlanner(new DeploymentPlanner.DeploymentPlannerBuilder().preProcessors(preProcessors).postProcessors(postProcessors).typeContributors(deployedContributors).contributors(contributors).build()));
    }

    private List<Method> orderProcessors(Set<Method> methods) {
        ArrayList list = Lists.newArrayList(methods);
        Collections.sort(list, PROCESSOR_COMPARATOR);
        return list;
    }

    private ListMultimap<Operation, Method> registerDeployedContributors() {
        ArrayListMultimap deployedContributorMap = ArrayListMultimap.create();
        this.registerDeployedContributors(Create.class, Operation.CREATE, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Modify.class, Operation.MODIFY, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Destroy.class, Operation.DESTROY, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Noop.class, Operation.NOOP, (ListMultimap<Operation, Method>)deployedContributorMap);
        return deployedContributorMap;
    }

    private void registerDeployedContributors(Class<? extends Annotation> annotation, Operation operation, ListMultimap<Operation, Method> deployedContributorMap) {
        TreeSet<Method> typeContributors = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        typeContributors.addAll(this.checkDeployedContributors(Scannit.getInstance().getMethodsAnnotatedWith(annotation)));
        for (Method typeContributor : typeContributors) {
            deployedContributorMap.put((Object)operation, (Object)typeContributor);
        }
    }

    private Set<Method> registerContributors() {
        TreeSet<Method> contributors = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        contributors.addAll(this.checkContributors(Scannit.getInstance().getMethodsAnnotatedWith(Contributor.class)));
        return contributors;
    }

    private Set<Method> checkDeployedContributors(Set<Method> deployedContributors) {
        for (Method c : deployedContributors) {
            Preconditions.checkArgument((boolean)c.getReturnType().equals(Void.TYPE), (String)"DeployedContributor %s should have void return type.", (Object[])new Object[]{c});
            Class<?>[] parameterTypes = c.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length <= 2 && parameterTypes.length >= 1 ? 1 : 0) != 0, (String)"DeployedContributor %s should take 1 or 2 parameters.", (Object[])new Object[]{c});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(DeploymentPlanningContext.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, DeploymentPlanningContext.class});
            if (parameterTypes.length != 2) continue;
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(Delta.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, Delta.class});
        }
        return deployedContributors;
    }

    private Set<Method> checkContributors(Set<Method> contributors) {
        for (Method contributor : contributors) {
            Preconditions.checkArgument((boolean)contributor.getReturnType().equals(Void.TYPE), (String)"Contributor %s should have void return type.", (Object[])new Object[]{contributor});
            Class<?>[] parameterTypes = contributor.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 2 ? 1 : 0) != 0, (String)"Contributor %s should take 2 parameters.", (Object[])new Object[]{contributor});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(Deltas.class), (String)"Contributor %s should take %s as first parameter.", (Object[])new Object[]{contributor, Deltas.class});
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(DeploymentPlanningContext.class), (String)"Contributor %s should take %s as second parameter.", (Object[])new Object[]{contributor, DeploymentPlanningContext.class});
        }
        return contributors;
    }

    private Set<Method> checkProcessors(Set<Method> processors) {
        for (Method processor : processors) {
            Class<?> returnType = processor.getReturnType();
            Preconditions.checkArgument((returnType.equals(com.xebialabs.deployit.plugin.api.execution.Step.class) || returnType.equals(Step.class) || returnType.equals(List.class) ? 1 : 0) != 0, (String)"Pre/Post processor %s should have a Step or List<Step> return type.", (Object[])new Object[]{processor});
            Class<?>[] parameterTypes = processor.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Processor %s should take 1 parameter.", (Object[])new Object[]{processor});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(DeltaSpecification.class), (String)"Processor %s should take %s as first parameter.", (Object[])new Object[]{processor, DeltaSpecification.class});
        }
        return processors;
    }

    public static class HierarchyClassMethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method method, Method method1) {
            String name2;
            Class<?> class2;
            Class<?> class1 = method.getDeclaringClass();
            if (this.isSuperClass(class1, class2 = method1.getDeclaringClass())) {
                return -1;
            }
            if (this.isSuperClass(class2, class1)) {
                return 1;
            }
            String name1 = class1.getName();
            int nameComparison = name1.compareTo(name2 = class2.getName());
            if (nameComparison == 0) {
                return method.getName().compareTo(method1.getName());
            }
            return nameComparison;
        }

        boolean isSuperClass(Class<?> c1, Class<?> c2) {
            return c1.isAssignableFrom(c2) && !c1.getName().equals(c2.getName());
        }
    }
}

