package com.xebialabs.deployit.deployment.stager

import com.xebialabs.deployit.plugin.api.flow.{StagingTarget, StepExitCode, ExecutionContext, Step}
import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders

class StagedFileCleaningStep(target: StagingTarget, taskId: String) extends Step {

  override def getOrder: Int = DefaultOrders.DEPLOY_ARTIFACTS + 1

  override def getDescription: String = s"Delete files in ${target.getStagingDirectoryPath} on ${target.getName}"

  override def execute(ctx: ExecutionContext): StepExitCode = {

    lazy val taskStagingDir = target.getConnection.getFile(target.getStagingDirectoryPath).getFile(taskId)
    ctx.logOutput(s"Cleaning up task staging directory: $taskStagingDir")
    taskStagingDir.deleteRecursively()
    StepExitCode.SUCCESS
  }

  private[stager] def getStagingTarget = target
}
