package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.plugin.api.deployment.specification.{Operation, Delta}

trait OrchestratorUtil {
  protected def getDeployed(input: Delta) = if (input.getDeployed != null) input.getDeployed else input.getPrevious

  protected def getOrderForString(op:Operation) = op match {
    case Operation.DESTROY => Ordering.String.reverse
    case _                 => Ordering.String
  }

  protected def getOrderForInt(op:Operation) = op match {
    case Operation.DESTROY => Ordering.Int.reverse
    case _                 => Ordering.Int
  }

}
