package com.xebialabs.deployit.deployment.rules

import java.lang.reflect.Method
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext

object JavaProcessorInvokerRule {
  def buildName(processor: Method) = s"${processor.getDeclaringClass.getName}.${processor.getName}"
}

import JavaProcessorInvokerRule._

class JavaProcessorInvokerRule(processor: Method, scope: Scope) extends CanFireRule(buildName(processor), scope) {
  override def canFire(scopedObject: AnyRef, context: DeploymentPlanningContext): Boolean = ???

  override def doFire(scopedObject: AnyRef, context: DeploymentPlanningContext): Unit = ???
}
