package com.xebialabs.deployit.deployment.rules;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.Step;

import nl.javadude.scannit.Scannit;

public class StepClassScanner {

    public void scanSteps(RuleStore ruleStore) {
        Set<Class<?>> classes = Scannit.getInstance().getTypesAnnotatedWith(StepMetadata.class);
        for(Class<?> c: classes) {
            if(Step.class.isAssignableFrom(c)) {
                ruleStore.registerStepClass((Class<? extends Step>) c, c.getAnnotation(StepMetadata.class));
            }
        }
    }

}
