/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class StepPlan
extends Plan {
    public static final Function<StepWithDelta, Step> stepsWithDeltaToSteps = new Function<StepWithDelta, Step>(){

        public Step apply(StepWithDelta input) {
            return input.step;
        }
    };
    private ListMultimap<Integer, StepWithDelta> stepsMap = ArrayListMultimap.create();
    private List<Checkpoint> checkpoints = Lists.newArrayList();
    private Delta deltaUnderPlanning;

    public StepPlan(String description, List<ExecutionStateListener> listeners) {
        super(description, listeners);
    }

    public StepPlan(String description, Collection<Step> steps, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.addSteps(steps);
    }

    public StepPlan(String description, Collection<StepWithDelta> steps, List<Checkpoint> checkpoints, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.checkpoints = checkpoints;
        for (StepWithDelta step : steps) {
            this.stepsMap.put((Object)step.getStep().getOrder(), (Object)step);
        }
    }

    public void addStep(Step step) {
        this.stepsMap.put((Object)step.getOrder(), (Object)new StepWithDelta(step, this.deltaUnderPlanning));
    }

    public void addSteps(Collection<Step> steps) {
        for (Step step : steps) {
            this.addStep(step);
        }
    }

    public List<StepWithDelta> getStepsWithDelta() {
        ArrayList orderedKeys = Lists.newArrayList((Iterable)this.stepsMap.keySet());
        Collections.sort(orderedKeys);
        ArrayList steps = Lists.newArrayList();
        for (Integer key : orderedKeys) {
            steps.addAll(this.stepsMap.get((Object)key));
        }
        return steps;
    }

    public List<Step> getSteps() {
        return Lists.transform(this.getStepsWithDelta(), stepsWithDeltaToSteps);
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public Set<Checkpoint> findCheckpoints() {
        return Sets.newHashSet(this.getCheckpoints());
    }

    @Override
    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.println(" * " + this.getDescription());
        out.println("   " + Strings.repeat((String)"-", (int)this.getDescription().length()));
        ArrayListMultimap checkpointsByStep = ArrayListMultimap.create();
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpointsByStep.put((Object)checkpoint.getStep(), (Object)checkpoint);
        }
        int index = 0;
        for (StepWithDelta swo : this.getStepsWithDelta()) {
            out.format("%2s. (%3s) - %s  (%s)\n", ++index, swo.step.getOrder(), swo.step.getDescription(), swo.getClass().getSimpleName());
            if (!checkpointsByStep.containsKey((Object)swo.step)) continue;
            for (Checkpoint checkpoint : checkpointsByStep.get((Object)swo.step)) {
                out.format("            *checkpoint*  %s\n", checkpoint);
            }
        }
        if (index == 0) {
            out.format("<empty plan>", new Object[0]);
        }
        return writer;
    }

    public void setDeltaUnderPlanning(Delta delta) {
        this.deltaUnderPlanning = delta;
    }

    public static class Checkpoint
    implements Serializable {
        private Delta delta;
        private Operation operation;
        private Step step;

        public Checkpoint(Delta delta, Step step) {
            this(delta, step, delta.getOperation());
        }

        public Checkpoint(Delta delta, Step step, Operation operation) {
            this.delta = delta;
            this.step = step;
            this.operation = operation;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public Step getStep() {
            return this.step;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            switch (this.operation) {
                case CREATE: {
                    return String.format("%s %s", this.operation, this.delta.getDeployed());
                }
                case MODIFY: {
                    return String.format("%s from %s to %s", this.operation, this.delta.getPrevious(), this.delta.getDeployed());
                }
                case DESTROY: {
                    return String.format("%s %s", this.operation, this.delta.getPrevious());
                }
            }
            return this.operation.toString();
        }
    }

    public static class StepWithDelta {
        private Set<Delta> deltas = Sets.newHashSet();
        private Step step;

        public StepWithDelta(Step step, Delta delta) {
            if (delta != null) {
                this.deltas.add(delta);
            }
            this.step = step;
        }

        public StepWithDelta(Step step, Set<Delta> deltas) {
            this.deltas.addAll(deltas);
            this.step = step;
        }

        public Set<Delta> getDeltas() {
            return this.deltas;
        }

        public Step getStep() {
            return this.step;
        }
    }
}

