package com.xebialabs.deployit.deployment
package orchestrator

import java.util

import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification}
import com.xebialabs.deployit.plugin.api.udm.{Deployable, CompositePackage, Version}

import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._

import com.xebialabs.platform._
import collection.convert.wrapAll._
import scala.collection.mutable

trait PackageOrchestratorBase extends OrchestratorUtil {
  
  def matchDeployableIdByPackageId(delta:Delta, version:Version) =
    delta.correctDeployed.getDeployable.asInstanceOf[Deployable].getId.startsWith(version.getId)
  
  def getOrchestrations(spec: DeltaSpecification) = spec.getDeployedApplication.getVersion match {
    case comp: CompositePackage =>
      val orderForOperation = getOrderForInt(spec.getOperation)
      val previousVersions: util.List[Version] = Option(spec.getPreviousDeployedApplication).map(_.getVersion.asInstanceOf[CompositePackage].getPackages).getOrElse(new util.ArrayList[Version]())
      val indexedPackages: List[(Version, Int)] = (comp.getPackages ++ previousVersions).toList.zipWithIndex
      val versionToDeltas: Map[(Version, Int), mutable.Buffer[Delta]] = spec.getDeltas.groupBy(delta => indexedPackages.find(version => matchDeployableIdByPackageId(delta, version._1)).get)
      versionToDeltas.toList.sortBy(_._1._2)(orderForOperation)
        .map { case (v, ds) => interleaved(getDescriptionForPackage(spec.getOperation, v._1), ds)}
    case _ => List(new DefaultOrchestrator().orchestrate(spec))
  }
}

@Orchestrator.Metadata (name = "sequential-by-composite-package", description = "The sequential by composite package orchestrator")
class SequentialByPackageOrchestrator extends Orchestrator with PackageOrchestratorBase {
  def orchestrate(spec: DeltaSpecification) = serial(getDescriptionForSpec(spec), getOrchestrations(spec))
}

@Orchestrator.Metadata (name = "parallel-by-composite-package", description = "The parallel by composite package orchestrator")
class ParallelByPackageOrchestrator extends Orchestrator with PackageOrchestratorBase {
  def orchestrate(spec: DeltaSpecification) = parallel(getDescriptionForSpec(spec), getOrchestrations(spec))
}

/***
  *  Deprecated
  */
@Orchestrator.Metadata (name = "composite-package", description = "The sequential by package orchestrator (Deprecated)")
@Deprecated
class CompositePackageOrchestrator extends SequentialByPackageOrchestrator
