package com.xebialabs.deployit.deployment.planner;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;

import com.google.common.base.Strings;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

import static com.google.common.collect.Sets.newHashSet;

public abstract class CompositePlan extends Plan {

    private List<? extends Plan> subPlans;

    protected CompositePlan(String description, List<? extends Plan> subPlans, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.subPlans = subPlans;
    }

    public List<? extends Plan> getSubPlans() {
        return subPlans;
    }

    @Override
    public Set<StepPlan.Checkpoint> findCheckpoints() {
        Set<StepPlan.Checkpoint> checkpoints = newHashSet();

        for (Plan plan : getSubPlans()) {
            if (plan instanceof StepPlan) {
                checkpoints.addAll(((StepPlan) plan).getCheckpoints());
            } else {
                checkpoints.addAll(plan.findCheckpoints());
            }
        }

        return checkpoints;
    }

    protected static String indent(String str, int n) {
        StringBuilder sb = new StringBuilder();

        for (String s : str.split("\n")) {
            if (!s.isEmpty()) {
                sb.append(String.format("%" + n + "s", "")).append("|").append(s).append("\n");
            }
        }

        return sb.toString();
    }

    protected void writeBlockBoundery(final PrintWriter out, int off) {
        out.println(Strings.repeat("#", this.getDescription().length() + 12 + off));
    }
}
