package com.xebialabs.deployit.deployment.rules

import javax.annotation.PreDestroy

import com.xebialabs.deployit.deployment.planner.{SimplifyingDeploymentPlanner, OrderChunkingPlanner, SizeChunkingPlanner, Planner}
import akka.actor.ActorSystem
import com.xebialabs.platform.watcher.FileWatchActor
import com.typesafe.config.ConfigFactory
import grizzled.slf4j.Logging


class RuleBasedPlannerFactory(val system: ActorSystem) extends Logging {

  private lazy val fileWatcherActor = system.actorOf(FileWatchActor.props, "file-watch-actor")
  private lazy val registriesActor = system.actorOf(RegistriesActor.props(fileWatcherActor), "registriesActor")

  def this() = this(ActorSystem("PlannerActorSystem", ConfigFactory.load("planner")))

  def planner: Planner = {
    new SizeChunkingPlanner(new OrderChunkingPlanner(new SimplifyingDeploymentPlanner(new RuleBasedPlanner(registriesActor))))
  }

  @PreDestroy
  def shutdownTheSystem() = {
    debug("Shutting down the planning actor system...")
    system.shutdown()
  }
}
