package com.xebialabs.deployit.deployment.stager

import com.xebialabs.deployit.booter.local.utils.Closeables
import com.xebialabs.deployit.booter.local.utils.Closeables.closeQuietly
import com.xebialabs.deployit.plugin.api.flow.{StagingTarget, StepExitCode, ExecutionContext, Step}
import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders
import com.xebialabs.overthere.OverthereConnection

class StagedFileCleaningStep(target: StagingTarget, taskId: String) extends Step {

  override def getOrder: Int = DefaultOrders.DEPLOY_ARTIFACTS + 1

  override def getDescription: String = s"Delete files in ${target.getStagingDirectoryPath} on ${target.getName}"

  override def execute(ctx: ExecutionContext): StepExitCode = {

    val c: OverthereConnection = target.getConnection
    try {
      lazy val taskStagingDir = c.getFile(target.getStagingDirectoryPath).getFile(taskId)
      ctx.logOutput(s"Cleaning up task staging directory: $taskStagingDir")
      taskStagingDir.deleteRecursively()
      StepExitCode.SUCCESS
    } finally {
      closeQuietly(c)
    }
  }

  private[stager] def getStagingTarget = target
}
