package com.xebialabs.deployit.deployment.stager

import com.xebialabs.deployit.plugin.api.flow.{StepExitCode, ExecutionContext, Step, StageableStep}
import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders
import com.xebialabs.deployit.deployment.stager.DeploymentStager.StagingFile
import com.xebialabs.overthere.{OverthereConnection, OverthereFile}

class StagingStep(stagingFile: StagingFile) extends Step {

  override def getOrder: Int = DefaultOrders.DEPLOY_ARTIFACTS - 1

  override def getDescription = s"Upload ${stagingFile.getSource.getFile.getName} to ${stagingFile.getTarget.getName}"

  override def execute(ctx: ExecutionContext): StepExitCode = {
    val connection: OverthereConnection = stagingFile.getTarget.getConnection
    try {
      val file: OverthereFile = stagingFile.get(connection, ctx)
      if (file != null) StepExitCode.SUCCESS else StepExitCode.FAIL
    } finally {
      connection.close()
    }
  }

  private[stager] def getStagingFile = stagingFile

  private[stager] def getStagingTarget = stagingFile.getTarget
}
