package com.xebialabs.deployit.deployment
package orchestrator

import com.xebialabs.deployit.engine.spi.orchestration.{Orchestration, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.udm.Container
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._

import com.xebialabs.platform._
import collection.convert.wrapAll._

trait ContainerOrchestratorBase extends OrchestratorUtil {
  
  def getOrchestrations(spec: DeltaSpecification) = {
    val orderForOperation = getOrderForString(spec.getOperation)
    val deltasByContainer = spec.getDeltas.toList.groupBy(_.correctDeployed.getContainer.asInstanceOf[Container])
    deltasByContainer.toList.sortBy(_._1.getName)(orderForOperation).map { case (c, ds) => interleaved(getDescriptionForContainer(spec.getOperation, c), ds) }
  }
}

@Orchestrator.Metadata (name = "sequential-by-container", description = "The sequential by container orchestrator")
class SequentialByContainerOrchestrator extends Orchestrator with ContainerOrchestratorBase {
  def orchestrate(spec: DeltaSpecification): Orchestration = serial(getDescriptionForSpec(spec), getOrchestrations(spec))
}

@Orchestrator.Metadata (name = "parallel-by-container", description = "The parallel by container orchestrator")
class ParallelByContainerOrchestrator extends Orchestrator with ContainerOrchestratorBase {
  def orchestrate(spec: DeltaSpecification): Orchestration = parallel(getDescriptionForSpec(spec), getOrchestrations(spec))
}

/***
 *  Deprecated
 */
@Orchestrator.Metadata (name = "container-by-container-serial", description = "The sequential by container orchestrator (Deprecated)")
@Deprecated
class ContainerByContainerSerialOrchestrator extends SequentialByContainerOrchestrator
