package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.plugin.api.flow.Step
import java.lang.reflect.Field

import scala.reflect.ClassTag

object StepParameterDescriptor{
  implicit class Utils(descriptor: StepParameterDescriptor) {
    def isFieldOfType[T : ClassTag] = implicitly[ClassTag[T]].runtimeClass.isAssignableFrom(descriptor.field.getType)
  }
}

case class StepParameterDescriptor(description: String, field: Field, required: Boolean)

case class StepDescriptor(name: String, implementationClass: Class[_ <: Step], parameters: Map[String, StepParameterDescriptor])
