package com.xebialabs.deployit.deployment.rules

import com.xebialabs.xlplatform.sugar.ResourcesSugar

import scala.xml._
import grizzled.slf4j.Logging
import javax.xml.validation.SchemaFactory
import javax.xml.XMLConstants._
import javax.xml.transform.stream.StreamSource
import scala.xml.Source.fromInputStream
import java.net.URL
import ResourceManagement._

object XmlReader extends Logging with ResourcesSugar{

  private type Parser = Elem => Unit

  def loadAllAndParse(resourceName: String)(parser: Parser) = resources(resourceName) foreach (loadValidateParse(_)(parser))

  private[rules] def loadValidateParse(fileResource: URL)(parser: Parser) = {
    debug(s"Loading file [$fileResource].")
    validateFile(fileResource)
    using(fileResource.openStream()) { resourceAsStream =>
      parser(XML.load(fromInputStream(resourceAsStream)))
    }
  }

  private def validateFile(fileResource: URL) {
    debug(s"Validating file [$fileResource]")
    val schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI)
    val schema = schemaFactory.newSchema(resource(rulesXsdLocation))
    val validator = schema.newValidator()
    using(fileResource.openStream()) { s =>
      validator.validate(new StreamSource(s))
    }
  }
}
