package com.xebialabs.deployit.deployment.rules

import scala.collection.mutable
import grizzled.slf4j.Logging

class SimpleStepRegistry extends StepRegistry with Logging{

  /**
   * Step Registry
   */
  private final val stepsByName = mutable.Map[String, StepDescriptor]()

  override def registerStep(stepDescriptor: StepDescriptor) = {
    if (stepsByName.isDefinedAt(stepDescriptor.name)) {
      val implClass = stepDescriptor.implementationClass
      throw new IllegalArgumentException(s"Duplicate step name ${stepDescriptor.name}. Found both [${implClass.getName}}] and [${implClass.getName}}]")
    }
    debug(s"Registering step ${stepDescriptor.name} with implementation ${stepDescriptor.implementationClass}")
    stepsByName(stepDescriptor.name) = stepDescriptor
  }

  override def getStepDescriptor(name: String): StepDescriptor = stepsByName.getOrElse(name, throw new IllegalArgumentException(s"Step $name could not be found"))
}
