package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

import java.io.Writer;
import java.util.List;
import java.util.Set;

public abstract class Plan {

    private String description = "";

    private List<ExecutionStateListener> listeners;

    protected Plan(String description, final List<ExecutionStateListener> listeners) {
        this.listeners = listeners;
        this.description = description;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public abstract Writer writePlan(Writer writer);

    public abstract Set<StepPlan.Checkpoint> findCheckpoints();

    public String getDescription() {
        return description;
    }
}
