package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.deployment.planner.{StepPlan, DefaultDeploymentPlanningContext}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Operation, DeltaSpecification}
import com.xebialabs.deployit.plugin.api.services.Repository
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication

object RulePlanningContext {
  def apply(spec: DeltaSpecification, stepRegistry: StepRegistry, readOnlyRepository: Repository, plan: StepPlan) = {
    val deployedApplication = spec.getOperation match {
      case Operation.DESTROY => null
      case _ => spec.getDeployedApplication
    }
    new RulePlanningContext(deployedApplication, spec.getPreviousDeployedApplication, readOnlyRepository, plan, spec.getOperation) {
      override def getStepRegistry: StepRegistry = stepRegistry
    }
  }
}

sealed abstract class RulePlanningContext(deployedApplication: DeployedApplication, previousDeployedApplication: DeployedApplication,
                                          readOnlyRepository: Repository, plan: StepPlan, operation: Operation)
  extends DefaultDeploymentPlanningContext(deployedApplication, previousDeployedApplication, readOnlyRepository, plan) {
  def getStepRegistry: StepRegistry
  def backwardCompatible: RulePlanningContext = {
    val deployedApp = operation match {
      case Operation.DESTROY => previousDeployedApplication
      case _ => deployedApplication
    }
    val stepRepository = getStepRegistry
    new RulePlanningContext(deployedApp, previousDeployedApplication, readOnlyRepository, plan, operation) {
      override def getStepRegistry: StepRegistry = stepRepository
    }
  }
}