package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

class DummyStepPlanner(wrappedPlanner: Planner) extends Planner {

  import collection.convert.wrapAll._

  override def plan(spec: DeltaSpecification, repository: Repository): PhasedPlan = {
    val plan = wrappedPlanner.plan(spec, repository)

    if (hasSteps(plan)) {
      plan
    } else {
      val description = findDescriptionFromStepPlan(plan).getOrElse("Deploying")
      val sp = new StepPlan(description, List(new RepositoryUpdateStep(spec = spec)), plan.getListeners)
      new PhasedPlan(List(new PlanPhase(sp, plan.getDescription, plan.getListeners)), plan.getListeners)
    }
  }

  def findDescriptionFromStepPlan(plan: Plan):Option[String] = plan match {
    case ps: PhasedPlan => ps.phases.flatMap(findDescriptionFromStepPlan).headOption
    case pp: PlanPhase => findDescriptionFromStepPlan(pp.plan)
    case cp: CompositePlan => cp.getSubPlans.flatMap(findDescriptionFromStepPlan).headOption
    case sp: StepPlan => Option(sp.getDescription)
  }

  def hasSteps(plan: Plan): Boolean = plan match {
    case ps: PhasedPlan => ps.phases.toList.foldLeft(false)((result, p) => result || hasSteps(p))
    case pp: PlanPhase => hasSteps(pp.plan)
    case cp: CompositePlan => cp.getSubPlans.toList.foldLeft(false)((result, p) => result || hasSteps(p))
    case sp: StepPlan => !sp.getSteps.isEmpty
  }
}